/*
	File:		BaseWindow.cp

	Contains:	Base class for a window.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(MAA)	Matt Ackeret
		(edv)	Ed Voas

	Change History (most recent first):

		 <4>	10/28/97	MAA		Change DrawMenuBar to InvalMenuBar
		 <3>	10/28/97	edv		Use RadioGroup control!
		 <2>	 10/8/97	MAA		Add DrawMenuBar in destructor
		 <1>	 9/11/97	edv		First checked in.
*/

#include <MacWindows.h>
#include "BaseWindow.h"

BaseWindow::BaseWindow()
{
	fWindow = nil;
}

BaseWindow::BaseWindow( SInt16 resID )
{
	fWindow = GetNewCWindow( resID, NULL, (WindowRef)-1L );
	((WindowPeek)fWindow)->windowKind = 2000;
	SetWRefCon( fWindow, (long)this );
}

BaseWindow::~BaseWindow()
{
	MenuHandle theMenu;
	
	if ( fWindow ) DisposeWindow( fWindow );

	theMenu = GetMyMenu();
	
	if (theMenu)
	{
 		DeleteMenu( (**theMenu).menuID );
 		DrawMenuBar();
	}
}

void
BaseWindow::Idle()
{
}

void
BaseWindow::AdjustMenus()
{
}

void
BaseWindow::HandleMenuSelection( SInt16 menuID, SInt16 itemNo )
{
#pragma unused( menuID, itemNo )
}

void
BaseWindow::Activate( EventRecord& )
{
	MenuHandle theMenu = GetMyMenu();
	
	if ( theMenu )
	{
		InsertMenu( theMenu, 0 );
		DrawMenuBar();
	}
}

void
BaseWindow::Deactivate( EventRecord& )
{
	MenuHandle theMenu = GetMyMenu();

	if ( theMenu )
	{
		DeleteMenu( (**theMenu).menuID );
		InvalMenuBar();
	}
}

void
BaseWindow::Update( EventRecord& )
{
	BeginUpdate( fWindow );
	Draw();
	EndUpdate( fWindow );
}

void
BaseWindow::Draw()
{
}

void
BaseWindow::HandleKeyDown( EventRecord& )
{
}

void
BaseWindow::Resize( SInt16 width, SInt16 height )
{
	SizeWindow( fWindow, width, height, true );
}

void
BaseWindow::HandleClick( EventRecord& event )
{
#pragma unused( event )
}

MenuHandle BaseWindow::GetMyMenu(void)
{
	return(nil);  // if someone hasn't overridden this, they don't have a menu to get!
}

